﻿var reports = {
    context: $(".v-reports"),
    datatable: null,
    treeview: null,
    canManagePermissions: $("#CanManagePermissions").val() == "True",
    initializeDataTable: function (folderId) {
        this.datatable = $(".h-reportsTable", this.context).a4datatable({
            advancedFilter: true,
            allowRowSelection: function (data) { return voxco.security.has('DELETE', data.Permissions); },
            height: "full",
            ajaxAction: a4.getAction("GetReports", "Project", "Reporting"),
            ajaxParams: { "parentFolderId": folderId },
            columns: [
                { "Name": "Id", "Title": resources.Id, "Visible": false, "Key": true },
                { "Name": "Name", "Title": resources.Name, "Class": "itemName", "HideInSelector": true },
                { "Name": "Description", "Title": resources.Description },
                { "Name": "Type", "Title": resources.Type, "Type": "enum", "EnumType": "CommandCenterReportType" },
                { "Name": "CreatedOn", "Title": resources.CreatedOn, "Type": "DateTime" },
                { "Name": "ModifiedOn", "Title": resources.ModifiedOn, "Type": "DateTime" },
                { "Name": "ModifiedByName", "Title": resources.ModifiedBy }
            ],
            stateKey: "ProjectReports",
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return voxco.security.has('DELETE', data.Permissions); } }
            ],
            contextMenuItems: [
                { "Action": "view", "Label": resources.View, "DisplayCondition": function (data) { return voxco.security.has('EXECUTE', data.Permissions); } },
                { "Action": "edit", "Label": resources.Edit, "DisplayCondition": function (data) { return voxco.security.has('READ', data.Permissions); } },
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return voxco.security.has('DELETE', data.Permissions); } }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "view":
                        window.open(a4.getAction("ViewReport", "Project", "Reporting", { id: row.Id, reportType: row.TypeName }),"_blank");
                        break
                    case "edit":
                        window.location = a4.getAction("EditReport", "Project", "Reporting", { id: row.Id });
                        break
                    case "delete":
                        reports.deleteReports([row.Id]);
                        break;
                    case "permissions":
                        modalDialog.showWindow(a4.getAction("ItemPermissionsEditor", "Users", "Settings", { id: row.Id, name: row.Name, objectType: "Report" }), 680, 600);
                        break;
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.map(rows, function (row) { return row.Id });

                if (action == "delete") {
                    reports.deleteReports(ids);
                }
            },
            quickFilter: {
                "Items": [
                    { "Label": resources.CallResult, "AjaxParams": { "type": "CallResult" } },
                    { "Label": resources.CapiTracking, "AjaxParams": { "type": "CapiTracking" } },
                    { "Label": resources.CrossTab, "AjaxParams": { "type": "CrossTab" } },
                    { "Label": resources.Monitoring, "AjaxParams": { "type": "Monitoring" } },
                    { "Label": resources.OpenEnd, "AjaxParams": { "type": "OpenEnd" } },
                    { "Label": resources.PauseTime, "AjaxParams": { "type": "PauseTime" } },
                    { "Label": resources.Productivity, "AjaxParams": { "type": "Productivity" } },
                    { "Label": resources.Questionnaire, "AjaxParams": { "type": "Questionnaire" } },
                    { "Label": resources.Quotas, "AjaxParams": { "type": "Quotas" } },
                    { "Label": resources.CallInbound, "AjaxParams": { "type": "CallInbound" } }
                ]
            },
            localizableTexts: { "All": resources.AllProjectReports, "Search": resources.SearchProjectReports },            
            loadData: function (event, data) {
                var folder = data.result.additionalData.folder;
                reports.toggleNewReportMenu(folder);
            }
        });
    },
    initializeTreeView: function () {
        this.treeview = $(".h-reportFolders", this.context).a4listview({
            ajaxAction: a4.getAction("GetReportFolders", "Project", "Reporting"),
            stateKey: "ProjectReports",
            draw: function (event, data) {
                var folder = data.selectedNode;
                var folderId = folder ? (folder.Id || 0) : 0;

                if (reports.datatable) {
                    reports.datatable.a4datatable("option", "ajaxParams", { "parentFolderId": folderId });
                    reports.datatable.a4datatable("refresh");
                }
                else {
                    reports.initializeDataTable(folderId);
                }
            },
            highlightFirstNode: true,
            selectNode: function (event, data) {
                reports.datatable.a4datatable("option", "ajaxParams", { "parentFolderId": data.node.Id });
                reports.datatable.a4datatable("refresh", true);
            },
            actionButtons: [
                { Action: "delete", Label: resources.Delete, Icon: "remove", DisplayCondition: function (data) { return data.CanBeDeleted; } },
                { Action: "properties", Label: resources.Properties, Icon: "edit", DisplayCondition: function (data) { return data.CanBeRead; } }
            ],
            actionButtonClick: function (event, data) {
                var action = data.action;
                var folderId = data.node.Id;

                switch (action) {
                    case "properties":
                        modalDialog.showWindow(a4.getAction("EditFolder", "Project", "Reporting", { id: folderId }), 250, 600, { afterClose: function () { reports.treeview.a4listview("refresh") } });
                        break;
                    case "delete":
                        modalDialog.showConfirmDialog(confirmDeleteItemResources, function () {
                            a4.callServerMethod(a4.getAction("DeleteFolder", "Project", "Reporting"), { id: folderId },
                                function (result) {
                                    reports.treeview.a4listview("refresh");
                                });
                        }, 250, 500, true, { "count": 1 });
                        break;
                    case "permissions":
                        modalDialog.showWindow(a4.getAction("ItemPermissionsEditor", "Users", "Settings", { id: folderId, name: data.node.Name, objectType: "ReportFolder" }), 680, 600);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchProjectReportFolders }
        });
    },
    bindEvents: function () {
        $(".h-newReportMenu").on("click", "li.h-newReport", function () {
            var selectedFolder = $(".h-reportFolders").a4listview("getHighlightedNode");

            var type = $(this).attr("data-type");

            window.location = a4.getAction("CreateReport", "Project", "Reporting", { type: type, folderid: selectedFolder.Id });
        });

        $(".h-newReportMenu").on("click", "li.h-newFolder", function () {
            var selectedFolder = $(".h-reportFolders").a4listview("getHighlightedNode");

            var selectedFolderId = selectedFolder ? selectedFolder.Id : $("#RootFolderId").val();

            modalDialog.showWindow(a4.getAction("EditFolder", "Project", "Reporting", { parentId: selectedFolderId }), 250, 600, { afterClose: function () { reports.treeview.a4listview("refresh") } });
        });
    },
    toggleNewReportMenu: function (folder) {        
        if (folder) {
            $("#main-header .h-newReportMenu .h-newReport", reports.context).each(function () {
                var reportType = $(this).attr("data-type");
                $(this).toggleClass("hidden", !folder["HasAccessTo" + reportType]);
            });

            $("#main-header .h-newReportMenu .h-newFolder", reports.context).toggleClass("hidden", !folder.CanBeCreated);
        }

        var canCreateReports = $("#main-header .h-newReportMenu .h-newReport:not(.hidden)", reports.context).length > 0;
        var canCreateFolders = $("#main-header .h-newReportMenu .h-newFolder:not(.hidden)", reports.context).length > 0;

        $("#main-header .h-newReportMenu", reports.context).toggle(canCreateReports || canCreateFolders);
        $("#main-header .h-newReportMenu .divider", reports.context).toggleClass("hidden", !canCreateReports || !canCreateFolders);
    },
    deleteReports: function (ids) {
        modalDialog.showConfirmDialog(confirmDeleteItemResources, function () {
            a4.callServerMethod(a4.getAction("DeleteReports", "Project", "Reporting"), { ids: ids },
                function (result) {
                    reports.treeview.a4listview("refresh");
                });
        }, null, null, true, { "count": ids.length });
    }
}

$(document).ready(function () {
    if (reports.context.length > 0) {
        reports.initializeTreeView();
        reports.bindEvents();
    }
});